﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using UbiUnityLibrary;

namespace UPnPToaster {
    public partial class Form1 : Form {

        UPnPServer device;

        public Form1() {
            InitializeComponent();
            this.pictureBox1.SizeMode = PictureBoxSizeMode.Zoom;
        }

        private void Form1_Load(object sender, EventArgs e) {
            device = new UPnPServer(1800, 1.0, "\\");

            System.Collections.Generic.Dictionary<UbiUnityLibrary.UPnPServerAttribute, string> deviceAttribute = new System.Collections.Generic.Dictionary<UbiUnityLibrary.UPnPServerAttribute, string>();
            deviceAttribute.Add(UPnPServerAttribute.FriendlyName, "the smart toaster");
            deviceAttribute.Add(UPnPServerAttribute.Manufacturer, "");
            deviceAttribute.Add(UPnPServerAttribute.ManufacturerURL, "");
            deviceAttribute.Add(UPnPServerAttribute.ModelName, "Toaster 3000");
            deviceAttribute.Add(UPnPServerAttribute.ModelDescription, "Toaster 3000");
            deviceAttribute.Add(UPnPServerAttribute.ModelNumber, "1.0");
            deviceAttribute.Add(UPnPServerAttribute.HasPresentation, "false");
            deviceAttribute.Add(UPnPServerAttribute.DeviceURN, "urn:schemas-upnp-org:device:Toaster3000:1");
            device.SetAttributes(deviceAttribute);

            device.AddService(1, "urn:upnp-org:serviceId:Toaster3000:0", "urn:schemas-upnp-org:service:Configuration:1", true, this);

            System.Collections.Generic.Dictionary<string, string> association = new System.Collections.Generic.Dictionary<string, string>();
            association.Clear();
            association.Add("Toast", "isToasting");
            device.AddStateVariable("urn:upnp-org:serviceId:Toaster3000:0", "Toasting", Toasting, association);

            System.Collections.Generic.List<string> methods = new System.Collections.Generic.List<string>();
            methods.Add("Toast");
            device.AddMethodRange("urn:upnp-org:serviceId:Toaster3000:0", methods);


            device.Start();
        }

        private bool _toasting;
        public bool Toasting
        {
            get
            {
                return _toasting;
            }
            set
            {
                ChangePictureState(value);
                _toasting = value;
                device.SetStateVariable("urn:upnp-org:serviceId:Toaster3000:0", "Toasting", _toasting);
            }
        }

        public void ChangePictureState(bool value) {
            if (pictureBox1.InvokeRequired) {
                MethodInvoker del = delegate { ChangePictureState(value); };
                this.Invoke(del);
                return;
            }
            pictureBox1.Image = value ? Properties.Resources.toaster_in : Properties.Resources.toaster_out;
            pictureBox1.Refresh();
        }

        private bool started = false;
        public void StartDevice() {
            device.Start();
            started = true;
        }

        public void StopDevice() {
            device.Stop();
            started = false;
        }

        public bool isStarted() {
            return started;
        }

        public async void Toast() {
            Toasting = true;

            await Task.Delay(5000);

            Toasting = false;
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e) {
            device.Stop();
            device.Dispose();
        }

        private void Form1_DoubleClick(object sender, EventArgs e) {
            Toast();
        }
    }
}
